/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.network.node;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface INetworkNode {
    public int getEnergyUsage();

    @Nonnull
    public ItemStack getItemStack();

    public void onConnected(INetwork var1);

    public void onDisconnected(INetwork var1);

    public boolean canUpdate();

    default public boolean isEnabled() {
        return true;
    }

    @Nullable
    public INetwork getNetwork();

    @Deprecated
    default public void update() {
        throw new RuntimeException("Override #updateNetworkNode");
    }

    @Deprecated
    default public BlockPos getPos() {
        throw new RuntimeException("Override #getNetworkNodePos");
    }

    @Deprecated
    default public World getWorld() {
        throw new RuntimeException("Override #getNetworkNodeWorld");
    }

    @Deprecated
    default public void markDirty() {
        throw new RuntimeException("Override #markNetworkNodeDirty");
    }

    default public void updateNetworkNode() {
        this.update();
    }

    default public BlockPos getNetworkNodePos() {
        return this.getPos();
    }

    default public World getNetworkNodeWorld() {
        return this.getWorld();
    }

    default public void markNetworkNodeDirty() {
        this.markDirty();
    }

    public NBTTagCompound write(NBTTagCompound var1);

    public String getId();

    default public boolean isTickable() {
        return true;
    }
}

